﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Ext.Net;
using Newtonsoft.Json;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.Xml.Xsl;
using ext = Ext.Net;

//setup an alias for all direct method calls on this page
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "PATSUMMARY")]

public partial class tbipat_summary : System.Web.UI.Page
{
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void InitPlan(string strPatPWEventID)
    {
        /*load the plan tab*/
        ucPlan.InitializeControl2(strPatPWEventID);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void InitEncounter(string strPatPWID, string strPatPWEventID)
    {
        if (CDataUtils2.ToLong(strPatPWEventID) > 0)
        {
            //get the pathway event
            CCPA cpa = new CCPA();
            DataSet ds = cpa.GetPatPWEventByIDDS(Master,
                                                 Master.SelectedPatientID,
                                                 CDataUtils2.ToLong(strPatPWEventID));

            //show/hide buttons as needed
            if (!CDataUtils2.IsEmpty(ds))
            {
                long lStatus = CDataUtils2.GetDSLongValue(ds, "STATUS");
                
                //keep the event status
                Master.EventStatus = lStatus;

                if (lStatus == 2)
                {
                    btnTreeEvents.Disable();
                    //can always add event btnTreeAddEvent.Disable();
                }
                else
                {
                    btnTreeEvents.Enable();
                    //can always add event btnTreeAddEvent.Disable();
                }
            }
            
            /*load the outcomes tab, will only load if we switch events.*/
            ucOutcomeMeasures.InitializeControl(strPatPWEventID);

            /*load the plan tab, will only load if we switch events.*/
            ucPlan.InitializeControl(strPatPWEventID);

            /*load the note*/
            InitializeNote(strPatPWEventID);
        }

        /*load the medical history tab, will only load if we switch events.*/
        if (CDataUtils2.ToLong(strPatPWID) > 0)
        {
            if (CDataUtils2.ToLong(strPatPWEventID) > 0)
            {
                ucMedicalHx.InitializeControl(strPatPWID, strPatPWEventID);
            }
        }
    }


    /// <summary>
    /// US:7112 Selected patient pathway event id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["summPatPWEventID"] != null)
            {
                strValue = Session["summPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["summPatPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// US:7112 Selected patient pathway event id
    /// </summary>
    public string PatPWID
    {
        get
        {
            string strValue = "";
            if (Session["UCCCPWEventID"] != null)
            {
                strValue = Session["UCCCPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["UCCCPWEventID"] = Convert.ToString(value); }
    }

    /// <summary>
    /// currently selected pathways
    /// </summary>
    public string SelectedPathways
    {
        get
        {
            string strValue = "";
            if (Session["SelectedPathways"] != null)
            {
                strValue = Session["SelectedPathways"].ToString();
            }

            return strValue;
        }
        set { Session["SelectedPathways"] = Convert.ToString(value); }
    }


    //[DirectMethod(ShowMask = true, Msg="<span role='alert'>Please wait.</span>")]
    ///// <summary>
    /////Initialize the note
    ///// </summary>
    ///// <param name="strPatPWEventID"></param>
    ///// <returns></returns>
    //public void ShowEventTabs()
    //{
    //    ////hide the instrument edit tab
    //    //tpPatientSummary.HideTab("pnlInstruments");

    //    ////show event edit tabs also just in case they are not visible
    //    //tpPatientSummary.ShowTab("pnlOutcomes", 0);
    //    //tpPatientSummary.ShowTab("pnlPlan", 1);
    //    //tpPatientSummary.ShowTab("pnlNote", 2);
    //    //tpPatientSummary.ShowTab("pnlMedicalHx", 3);

    //}

    //[DirectMethod(ShowMask = true, Msg="<span role='alert'>Please wait.</span>")]
    ///// <summary>
    /////Initialize the note
    ///// </summary>
    ///// <param name="strPatPWEventID"></param>
    ///// <returns></returns>
    //public void InstrumentSelProc(int nView, int nState)
    //{
    //    ////Instrument Hx
    //    //if (nView == 0)
    //    //{
    //    //    tpPatientSummary.ShowTab("pnlInstruments", 0);
    //    //    tpPatientSummary.SetActiveTab(0);

    //    //    switch (nState)
    //    //    {
    //    //        case 0:
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentReportContainer");
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentFormContainer");
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentTrendContainer");
    //    //            break;

    //    //        case 1:
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentReportContainer", 0);
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentFormContainer");
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentTrendContainer", 1);
    //    //            break;
    //    //    }

    //    //    //default to the first tab
    //    //    pnlInstrumentContainer.SetActiveTab(0);

    //    //    //hide...
    //    //    tpPatientSummary.HideTab("pnlOutcomes");
    //    //    tpPatientSummary.HideTab("pnlPlan");
    //    //    tpPatientSummary.HideTab("pnlNote");
    //    //    tpPatientSummary.HideTab("pnlMedicalHx");
    //    //}

    //    ////Schedule
    //    //if (nView == 1)
    //    //{
    //    //    tpPatientSummary.ShowTab("pnlInstruments", 0);

    //    //    switch (nState)
    //    //    {
    //    //        case 0:
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentReportContainer");
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentFormContainer", 0);
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentTrendContainer", 1);
    //    //            break;

    //    //        case 1:
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentReportContainer", 0);
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentFormContainer", 1);
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentTrendContainer", 2);
    //    //            break;

    //    //        case 2:
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentReportContainer");
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentFormContainer");
    //    //            pnlInstrumentContainer.HideTab("pnlInstrumentTrendContainer");
    //    //            break;
                
    //    //        //instrument is locked
    //    //        case 3:
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentReportContainer", 0);
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentFormContainer", 1);
    //    //            pnlInstrumentContainer.ShowTab("pnlInstrumentTrendContainer", 2);
    //    //            break;
    //    //    }

    //    //    //default to the first tab
    //    //    pnlInstrumentContainer.SetActiveTab(0);

    //    //    //show event edit tabs also just in case they are not visible
    //    //    tpPatientSummary.ShowTab("pnlOutcomes", 1);
    //    //    tpPatientSummary.ShowTab("pnlPlan", 2);
    //    //    tpPatientSummary.ShowTab("pnlNote", 3);
    //    //    tpPatientSummary.ShowTab("pnlMedicalHx", 4);
    //    //}
    //}

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///Initialize the note
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    /// <returns></returns>
    public bool InitializeNote(string strPatPWEventID)
    {
        //don't reload the if already loaded
        if (strPatPWEventID == PatPWEventID)
        {
            return true;
        }

        //keep the patient pathway event id
        PatPWEventID = strPatPWEventID;

        //load the note
        LoadNote(PatPWEventID);

        return true;
    }

    /// <summary>
    /// US:7111 US:7109 US:7112 load the note
    /// </summary>
    /// <param name="strPatPWEventID"></param>
    protected void LoadNote(string strPatPWEventID)
    {
        //allow edit to start with
        btnEventNoteCommit.Enable();
        btnEventNoteSave.Enable();
        tfEventNote.ReadOnly = false;
        btnEventNoteSel.Enable();
        cboEventNoteTemplate.Enable();

        //get the note info for the event selected
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetPatPWEventByIDDS(Master,
                                             Master.SelectedPatientID,
                                             CDataUtils2.ToLong(strPatPWEventID));

        if (!CDataUtils2.IsEmpty(ds))
        {
            //get the status of the event 2 = closed
            long lStatus = Master.EventStatus;
            //CDataUtils2.GetDSLongValue(ds, "STATUS");

            //note title
            string strSEL_NOTE_TITLE = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_NOTE_TITLE"));
            if (strSEL_NOTE_TITLE == null)
            {
                strSEL_NOTE_TITLE = "";
            }
            Session["SEL_NOTE_TITLE"] = strSEL_NOTE_TITLE;
            string[] spltNT = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
            tfEventNoteTitle.Text = "";//HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_NOTE_TITLE"));
            if (spltNT.Length > 0)
            {
                tfEventNoteTitle.Text = spltNT[0];
            }                

            //note location
            string strSEL_NOTE_LOCATION = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_LOCATION"));
            if (strSEL_NOTE_LOCATION == null)
            {
                strSEL_NOTE_LOCATION = "";
            }
            Session["SEL_NOTE_LOCATION"] = strSEL_NOTE_LOCATION;
            string[] spltLoc = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
            tfEventNoteLocation.Text = ""; //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_LOCATION"));
            if (spltLoc.Length > 0)
            {
                tfEventNoteLocation.Text = spltLoc[0];
            }

            //cosigner
            string strSEL_NOTE_COSIGN = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_COSIGNER"));
            if (strSEL_NOTE_COSIGN == null)
            {
                strSEL_NOTE_COSIGN = "";
            }
            Session["SEL_NOTE_COSIGN"] = strSEL_NOTE_COSIGN;
            string[] spltCosign = strSEL_NOTE_COSIGN.Split(new Char[] { '^' });
            tfEvtNoteCosigner.Text = "";  //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_COSIGNER"));
            if (spltCosign.Length > 0)
            {
                tfEvtNoteCosigner.Text = spltCosign[0];
            }

            //consult
            string strSEL_NOTE_CONSULT = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_CONSULT"));
            if (strSEL_NOTE_CONSULT == null)
            {
                strSEL_NOTE_CONSULT = "";
            }
            Session["SEL_NOTE_CONSULT"] = strSEL_NOTE_CONSULT;
            string[] spltCons = strSEL_NOTE_CONSULT.Split(new Char[] { '^' });
            tfEvtNoteConsult.Text = strSEL_NOTE_CONSULT;  //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_CONSULT"));
            if (spltCons.Length > 0)
            {
                tfEvtNoteConsult.Text = spltCons[0];
            }

            //note text
            //tfEventNote.Text = CDataUtils2.Sanitize(CDataUtils2.GetDSStringValue(ds, "NOTE_TEXT"));
            tfEventNote.Text = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "NOTE_TEXT"));
            if (tfEventNote.Text == null)
            {
                tfEventNote.Text = "";
            }

            //if the note is commited, then disable edit
            if (lStatus == 2) //this note is closed
            {
                //set the text = the tiu note pushed up
                tfEventNote.Text = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_NOTE"));
                if (tfEventNote.Text == null)
                {
                    tfEventNote.Text = "";
                }


                //read only
                btnEventNoteCommit.Disable();
                btnEventNoteSave.Disable();
                tfEventNote.ReadOnly = true;
                btnEventNoteSel.Disable();
                cboEventNoteTemplate.Disable();

                ucOutcomeMeasures.PatPWEventID = "";
                ucOutcomeMeasures.InitializeControl(PatPWEventID);
                
                ucPlan.PatPWEventID = "";
                ucPlan.InitializeControl(PatPWEventID);
            }   
        }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7303 US:7109 Show confirm
    /// </summary>
    public void OnTIUNoteConfirm()
    {
        //check note title ien
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        if (strSEL_NOTE_TITLE == null)
        {
            strSEL_NOTE_TITLE = "";
        }
        string[] splitNoteTitle = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
        //tfEventNoteTitle.Text.Split(new Char[] { '^' });
        if (splitNoteTitle.Length < 2)//nothing to do
        {
            Master.ShowSystemFeedback("Please select a valid note title!", "Data Entry Error");
            return;

        }

        
        //check encounter
        string strSEL_NOTE_LOCATION = Convert.ToString(Session["SEL_NOTE_LOCATION"]);
        if (strSEL_NOTE_LOCATION == null)
        {
            strSEL_NOTE_LOCATION = "";
        }
        string[] splitEncounterID = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
            //tfEventNoteLocation.Text.Split(new Char[] { '^' });
        if (splitEncounterID.Length < 2)//nothing to do
        {
            Master.ShowSystemFeedback("Please select a valid note location!", "Data Entry Error");
            return;

        }
        
        //build warning
        taTIUAlert.FieldLabel = "Warning, you are about to commit this note to TIU. Once the note is committed it will be locked and no further changes can be made";
        
        taTIUAlert.Text = "";
        //taTIUAlert.Text += "\r\n\r\n";
        
        taTIUAlert.Text += "Note Title: " +  tfEventNoteTitle.Text;
        taTIUAlert.Text += "\r\n\r\n";

        taTIUAlert.Text += "Encounter Location: " + tfEventNoteLocation.Text;
        taTIUAlert.Text += "\r\n\r\n";

        if (!String.IsNullOrEmpty(tfEvtNoteConsult.Text))
        {
            taTIUAlert.Text += "Consult: " + tfEvtNoteConsult.Text;
            taTIUAlert.Text += "\r\n\r\n";
        }

        if (!String.IsNullOrEmpty(tfEvtNoteCosigner.Text))
        {
            taTIUAlert.Text += "Cosigner: " + tfEvtNoteCosigner.Text;
            taTIUAlert.Text += "\r\n\r\n";
        }

        
        //taTIUAlert.Text += "Note: " + tfEventNote.Text;
        //taTIUAlert.Text += "\r\n\r\n";

        //taTIUAlert.Text += ;
        taTIUAlert.Text += "\r\n";
        
        winTIUWarning.Show();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7303 US:7109 commit the note to tiu
    /// </summary>
    protected void OnEventDelete(object sender, DirectEventArgs e)
    {
        winDelEvent.Hide();

        CCPA cpa = new CCPA();
        cpa.DeleteEvent(Master, Master.SelectedPatientID, CDataUtils2.ToLong(ucEventAddInstrument.PatPWEventID));

        if (ucPlan.NextPatPWEventID == ucEventAddInstrument.PatPWEventID)
        {
            ucPlan.NextPatPWEventID = "";
        }

        PatPWEventID = ucEventAddInstrument.PatPWEventID;

        //re draw the events and hide the tabs
        this.OnPathwaySelect(CDataUtils2.ToLong(PatPWID), true);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "fnUpdateNoteHash")]
    /// <summary>
    ///US:7303 US:7109 commit the note to tiu
    /// </summary>
    public object CommitEventNote()
    {
        Session["PING_MDWS"] = "1";

        X.Mask.Hide();

        //get note title ien
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        string strNoteTitleIEN = "";
        string[] splitNoteTitle = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
        //tfEventNoteTitle.Text.Split(new Char[] { '^' });
        
        if (splitNoteTitle.Length < 2)//nothing to do
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("Please select a valid note title!", "Data Entry Error");
            return new { submitted = false };

        }
        strNoteTitleIEN = splitNoteTitle[1];

        //get encounter
        string strEncounterID = "";
        string strSEL_NOTE_LOCATION = Convert.ToString(Session["SEL_NOTE_LOCATION"]);

        string[] splitEncounterID = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
            //tfEventNoteLocation.Text.Split(new Char[] { '^' });
        
        if (splitEncounterID.Length < 2)//nothing to do
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("Please select a valid note location!", "Data Entry Error");
            return new { submitted = false };

        }
        strEncounterID = splitEncounterID[1];


        //get consult ien 
        string strSEL_NOTE_CONSULT = Convert.ToString(Session["SEL_NOTE_CONSULT"]);
        string strConsultIEN = "";
        string[] splitConsult = strSEL_NOTE_CONSULT.Split(new Char[] { '^' });
            //tfEvtNoteConsult.Text.Split(new Char[] { '^' });
        if (splitConsult.Length > 1)
        {
            strConsultIEN = splitConsult[1];
        }

        //get cosigner duz 
        string strSEL_NOTE_COSIGN = Convert.ToString(Session["SEL_NOTE_COSIGN"]);
        string strCosignerDUZ = "";
        string[] splitCosign = strSEL_NOTE_COSIGN.Split(new Char[] { '^' });
            //tfEvtNoteConsult.Text.Split(new Char[] { '^' });
        if (splitCosign.Length > 1)
        {
            strCosignerDUZ = splitCosign[1];
        }

        //get the clinic id
        long lClinicID = -1;
        string[] splitEncID = strEncounterID.Split(new Char[] { ';' });
        if (splitEncID.Length > 1)//valid string
        {
            lClinicID = CDataUtils2.ToLong(splitEncID[0]);
        }

        //write the note and return 
        string strTIUNoteID = "";
        string strTIUNote = "";
        CMDWSOps ops = new CMDWSOps(Master.GetDataObject());

        //select the patient in MDWS so that its the currently selected patient
        //this is just to make 100% sure the patient is selected
        string strPatID = "";
        CStatus stat = ops.TransferPatientByDFN(Master.Key,
                                                Master.DFN,
                                                out strPatID);

        //format the note
        string strNote = HttpUtility.HtmlDecode(tfEventNote.Text);
        strNote = strNote.Replace("\n", "\r\n");

        //write the note to MDWS
        CStatus status = ops.WriteNote2( Master.DFN,
                                         Master.DUZ,
                                         strNoteTitleIEN,
                                         strEncounterID,
                                         strNote,
                                         strConsultIEN,
                                         strCosignerDUZ,
                                         out strTIUNoteID,
                                         out strTIUNote );

        if (!status.Status)
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback(status.StatusComment, "Error writing note to TIU");
            return new { submitted = false };
        }

        //sometimes we error out for no reason this catches it....
        if (String.IsNullOrEmpty(strTIUNote) || CDataUtils2.ToLong(strTIUNoteID) < 1)
        {
            Session["PING_MDWS"] = null;

            string strErr = "An error occurred while writing the note, ";
            strErr += "if this error continues please contact your system administrator.";

            Master.ShowSystemFeedback(strErr, "Error writing note to TIU");
            return new { submitted = false };
        }


        // the note is successfully written to tiu so update the TBI data
        CPWEvent evt = new CPWEvent();
        bool bStatus = evt.WriteNote(Master,
                                     CDataUtils2.ToLong(PatPWEventID),
                                     Master.DFN,
                                     Master.DUZ,
                                     strEncounterID,
                                     strConsultIEN,
                                     strCosignerDUZ,
                                     strNoteTitleIEN,
                                     strTIUNoteID,
                                     strTIUNote,
                                     lClinicID,
                                     1,//todo and consult...
                                     strSEL_NOTE_TITLE,//tfEventNoteTitle.Text,
                                     strSEL_NOTE_LOCATION,//tfEventNoteLocation.Text,
                                     strSEL_NOTE_COSIGN,//tfEvtNoteCosigner.Text,
                                     strSEL_NOTE_CONSULT,//tfEvtNoteConsult.Text,
                                     HttpUtility.HtmlDecode(tfEventNote.Text));

        if (!bStatus)
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("The note was written to TIU, but failed to save to TBI CDS", "Error writing note to TIU");
            return new { submitted = false };
        }

        //lock it
        btnEventNoteCommit.Disable();
        btnEventNoteSave.Disable();
        tfEventNote.ReadOnly = true;
        btnEventNoteSel.Disable();
        cboEventNoteTemplate.Disable();
       
        //show the tiu note text just written
        tfEventNote.Text = strTIUNote;

        //reload the plan and outcome measures
        ucOutcomeMeasures.InitializeControl(CDataUtils2.ToLong(PatPWEventID));
        ucPlan.InitializeControl(CDataUtils2.ToLong(PatPWEventID));

        //reload the instrument hx
        GetAllPatPWEvtModules();

        //notify the user of success
        //Master.ShowSystemFeedback("The note was successfully written to TIU.", "Success");
        winTIUWarning.Close();

        Notification.Show(new NotificationConfig
        {
            PinEvent = "none",
            Plain = true,
            Header = false,
            Html = "The note was successfully written to TIU!"
        });

        Session["PING_MDWS"] = null;

        btnEventNoteSave.Disable();

        return new { submitted = true };
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void ReloadPlan(long lPatPWEventID)
    {
        ucPlan.InitializeControl(-1);
        ucPlan.InitializeControl(lPatPWEventID);
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "fnUpdateNoteHash")]
    /// <summary>
    ///US:7109 save note progress, used while the note is being written but before it is commited
    /// </summary>
    public void OnEventNoteSave()
    {
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        string strSEL_NOTE_CONSULT  = Convert.ToString(Session["SEL_NOTE_CONSULT"]);
        string strSEL_NOTE_LOCATION  = Convert.ToString(Session["SEL_NOTE_LOCATION"]);
        string strSEL_NOTE_COSIGN  = Convert.ToString(Session["SEL_NOTE_COSIGN"]);
        
        // the note is successfully written to tiu so update the TBI data
        CPWEvent evt = new CPWEvent();
        bool bStatus = evt.SaveNoteProgress(Master,
                                             CDataUtils2.ToLong(PatPWEventID),
                                             1,//todo...
                                             strSEL_NOTE_TITLE,//tfEventNoteTitle.Text,
                                             strSEL_NOTE_LOCATION,//tfEventNoteLocation.Text,
                                             strSEL_NOTE_COSIGN,//tfEvtNoteCosigner.Text,
                                             strSEL_NOTE_CONSULT,//tfEvtNoteConsult.Text,
                                             HttpUtility.HtmlDecode(tfEventNote.Text));

        if (!bStatus)
        {
            Master.ShowSystemFeedback("Failed to save note progress!", "Error saving note");
            return;
        }

        Master.ShowSystemFeedback("Note progress successfully saved.", "Success");
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 Load note template select
    /// </summary>
    public void OnTemplateSave()
    {
        //top, bot or replace
        string strTop = rdoTemplTop.Value.ToString();
        string strBot = rdoTemplBottom.Value.ToString();
        string strReplace = rdoTemplReplace.Value.ToString();

        //top
        if (strTop.ToUpper() == "TRUE")
        {
            tfEventNote.Text = HttpUtility.HtmlDecode(taTemplateText.Text) + "\r\n" + HttpUtility.HtmlDecode(tfEventNote.Text);
        }

        //bot
        if (strBot.ToUpper() == "TRUE")
        {
            tfEventNote.Text += "\r\n" + HttpUtility.HtmlDecode(taTemplateText.Text);
        }

        //replace
        if (strReplace.ToUpper() == "TRUE")
        {
            tfEventNote.Text = HttpUtility.HtmlDecode(taTemplateText.Text);
        }

        tfEventNote.Text = HttpUtility.HtmlDecode(tfEventNote.Text);

        //clear the text and close the popup
        taTemplateText.Text = "";
        wndTemplateText.Close();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 cancel note template select
    /// </summary>
    public void OnTemplateCancel()
    {
        //clear the text and close the popup
        taTemplateText.Text = "";
        wndTemplateText.Close();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 Load note template selected
    /// </summary>
    /// <param name="strTemplateID"></param>
    public void LoadNoteTemplate(string strTemplateID)
    {  
        CTemplate template = new CTemplate();

        if (!String.IsNullOrEmpty(strTemplateID) && !strTemplateID.Equals("null"))
        {
            string strParsedTemplate = template.GetParsedTemplateText2(Master,
                                                                       Master.SelectedPatientID,
                                                                       ucPlan.PatPWEventID, 
                                                                       Convert.ToInt32(strTemplateID));
            taTemplateText.Text = strParsedTemplate.Replace("\n\n\n\n", "\n");

            //tfEventNote.Text += strParsedTemplate;
            cboEventNoteTemplate.SelectedItems.Clear();
            cboEventNoteTemplate.UpdateSelectedItems();
        }

        wndTemplateText.Show();
    }


    /// <summary>
    ///US:7264 US:7109 US:7111 US:7112 US:5859 US:5963 US:5967 page load of the patient summary screen
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Master.EventStatus = -1;

            //start with the tree buttons disabled
            btnTreeEvents.Disable();
            //can always add event btnTreeAddEvent.Disable();
            //can always appy pathway btnTreeApplyPW.Disable();
        }

        //pass on the BaseMaster to user controls
        ucTBICDSInstrument.BaseMstr = Master;
        ucInstrumentSelection.BaseMstr = Master;
        ucEventAddInstrument.BaseMstr = Master;
        ucEventRemoveInstrument.BaseMstr = Master;
        ucEventEdit.BaseMstr = Master;

        ucNoteSelection.BaseMstr = Master;
        ucAssignPathway.BaseMstr = Master;
        ucOutcomeMeasures.BaseMstr = Master;
        ucPlan.BaseMstr = Master;
        ucMedicalHx.BaseMstr = Master;

        ucAdministration.BaseMstr = Master;

        if (!IsPostBack)
        {
            htxtSelectedPatientID.Value = Master.SelectedPatientID;

            //SelectedPathways = "";

            //hide tabs till something is selected
            //tpPatientSummary.HideTab("pnlInstruments");
            //tpPatientSummary.HideTab("pnlOutcomes");
            //tpPatientSummary.HideTab("pnlPlan");
            //tpPatientSummary.HideTab("pnlNote");
            //tpPatientSummary.HideTab("pnlMedicalHx");
            
            //clear the pathway and event
            PatPWEventID = "";
            PatPWID = "";
            
            //note title
            tfEventNoteTitle.Text = "";
            //note location
            tfEventNoteLocation.Text = "";
            //cosigner
            tfEvtNoteCosigner.Text = "";
            //consult
            tfEvtNoteConsult.Text = "";
            //note text
            tfEventNote.Text = "";
            
            //enable by default
            btnEventNoteCommit.Enable();
            btnEventNoteSave.Enable();
            tfEventNote.ReadOnly = false;
            btnEventNoteSel.Enable();
            cboEventNoteTemplate.Enable();

            //load the templates
            CTemplate tmpl = new CTemplate();
            DataSet dsTemplates = tmpl.GetTemplateDS(Master, CTemplate.TemplateTypeID.NOTES);
            //clear the combo
            cboEventNoteTemplate.GetStore().RemoveAll();
            cboEventNoteTemplate.Items.Clear();
            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            string strTemplatesJSON = cdc.GetJsonDSString(dsTemplates);
            storeEventNoteTemplate.SetDataFromJson(strTemplatesJSON);

            if (!X.IsAjaxRequest)
            {
                //reset the instruments user control
                ucTBICDSInstrument.m_lInstrumentID = 1;
                ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());

                //load instrument selection window control
                ucInstrumentSelection.InitializeControl();

                GetAllPatPWEvtModules();
            }

            //load pathways list
            LoadPatPathwaysList(); 
            
            //only render the most recent pathway
            RenderNewestPathwayEvents();

            //clear session var for instrument json
            Session.Remove("instrument_json");

            //set focus to the tree
            tpTxTree.Focus();
     
        }

        if (X.IsAjaxRequest)
        {
            //pnlInstrumentReportContainer.DoLayout();
        }
    }

  
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:5963 show the add instrument dialog
    /// </summary>
    public void OnShowAddEventInstrument()
    {
        ucEventAddInstrument.Show();
    }

    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:5963 show the add instrument dialog
    /// </summary>
    public void OnShowRemoveEventInstrument()
    {
        ucEventRemoveInstrument.Show();
    }

    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:5963 show the add instrument dialog
    /// </summary>
    public void OnShowEventEdt(int nType)
    {        
        ucEventEdit.Show(nType);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:5963 show the delete event dialog
    /// </summary>
    public void OnShowEventDel()
    {
        winDelEvent.Show();
    }

   
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// 
    /// </summary>
    public void OnShowAddEvent(long lPatPWID) { 
        //TODO:
        return;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7112 show the note selection dialog
    /// </summary>
    public void OnShowNoteSelection()
    {
        //initialize and show the control
        ucNoteSelection.InitializeControl( tfEventNoteTitle.Text,
                                           tfEventNoteLocation.Text,
                                           tfEvtNoteConsult.Text,
                                           tfEvtNoteCosigner.Text );
        ucNoteSelection.Show();
    }
    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///show the apply pathway dialog
    /// </summary>
    public void OnShowApplyPathway()
    {    
        ucAssignPathway.InitializeControl();
        ucAssignPathway.Show();
    }

  
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// 
    /// </summary>
    /// <param name="lPatPWEventID"></param>
    public void OnEditEvent(long lPatPWEventID)
    {
        //ucEditPWEvent.InitializeControl(lPatPWEventID);
        //ucEditPWEvent.Show();
        //ucInstrumentSelection.Show(lPatPWEventID);
        ucEventAddInstrument.PatPWEventID = Convert.ToString(lPatPWEventID);
        ucEventRemoveInstrument.PatPWEventID = Convert.ToString(lPatPWEventID);
        ucEventEdit.PatPWEventID = Convert.ToString(lPatPWEventID);

        //show the popup menu and clear the menu selection
        winEditEvent.Show();
        mplEditEvent.ClearSelection();

        //hide or show the delete menu option
        CCPA cpa = new CCPA();
        if (!cpa.AllowEventDelete(Master, Master.SelectedPatientID, lPatPWEventID))
        {
            miDelE.Hide();
        }
        else
        {
            miDelE.Show();
        }

        //tTxTree.SelectedNodes.Add(
        




    }

   
    #region LEFT_PANEL
    // ############################## LEFT PANEL ##############################

    /// <summary>
    /// Renders all pathways events associated to a patient
    /// </summary>
    public void RenderAllPWEvents() {
        //add nodes to the tree
        var nodes = GetPWEventNodes(String.Empty);
        tTxTree.Root.Add(nodes[0]);
    }

    /// <summary>
    /// renders all events for the newest pathway
    /// </summary>
    public void RenderNewestPathwayEvents()
    {
        long lPatPWID = -1;
        CCPA ccpa = new CCPA();
        DataSet ds = ccpa.GetPatPWDS(Master, Master.SelectedPatientID);

        //get the first pw id
        foreach (DataTable dt in ds.Tables)
        {
            foreach (DataRow dr in dt.Rows)
            {
                lPatPWID = CDataUtils2.GetDSLongValue(dr, "PAT_PW_ID");
                break;
            }
        }

        //simulate a pathway select event
        this.OnPathwaySelect(lPatPWID,true);

        //highlight the pathway list
        gpPathwaysList2.GetSelectionModel().Select(0);

    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public void RenderCurrentPathwayEvents()
    {
        this.OnPathwaySelect(CDataUtils2.ToLong(PatPWID),false);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// Render the filtered PW Evts nodes
    /// </summary>
    /// <param name="strPW"></param>
    public string LoadPathway(string strPW)
    {
        var nodes = GetPWEventNodes(strPW);
        //tTxTree.Root.Add(nodes[0]);
        return nodes.ToJson();
    }
    
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    ///
    /// </summary>
    public void OnPathwaySelect(string strJsonRecord)
    {
        //disable buttons until user selects event
        btnTreeEvents.Disable();
        //can always add event btnTreeAddEvent.Disable();

        long lPatPWID = CDataUtils2.ToLong(CDataUtils2.GetJsonRecordValue("PAT_PW_ID", strJsonRecord));
        string strPatPWID = CDataUtils2.GetJsonRecordValue("PAT_PW_ID", strJsonRecord);

        //keep the patient pathway event id
        PatPWID = strPatPWID;

        OnPathwaySelect(lPatPWID, true);      
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="lPatPWID"></param>
    public void OnPathwaySelect(long lPatPWID, bool bHideTabs)
    {
        //btnTreeEvents.Disable();

        tTxTree.GetRootNode().RemoveAll();

        //keep the patient pathway event id
        PatPWID = Convert.ToString(lPatPWID);
        ucEventEdit.PatPWID = PatPWID;

        //get the pathway events
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetPatPWEventDS(Master, Master.SelectedPatientID, lPatPWID);

        //load the tree
        Ext.Net.NodeCollection nodes = new Ext.Net.NodeCollection();
        Ext.Net.Node nRoot = new Node() { Expanded = true, EmptyChildren = true };
        CTxTree txtree = new CTxTree(Master, "PATSUMMARY");

        if (ds != null)
        {
            foreach (DataTable dt in ds.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {
                    if (!dr.IsNull("EVENT_TITLE"))
                    {
                        //event status 2 = closed and tiu note submitted
                        long lEventStatus = Convert.ToInt32(dr["STATUS"]);

                        //create the event node
                        ext.Node nPWEvt = new ext.Node()
                        {
                            Text = dr["EVENT_TITLE"].ToString(),
                            EmptyChildren = true,
                            Expanded = true,
                            CustomAttributes = { 
                                new ext.ConfigItem{
                                    Name = "is_event",
                                    Value = "true",
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "is_instrument",
                                    Value = "false",
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "item_type",
                                    Value = "evt_event",
                                    Mode = ext.ParameterMode.Value
                                },
                                 new ext.ConfigItem{
                                    Name = "pat_pw_id",
                                    Value = dr["PAT_PW_ID"].ToString(),
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "status",
                                    Value = dr["STATUS"].ToString(),
                                    Mode = ext.ParameterMode.Auto
                                },
                                new ext.ConfigItem{
                                    Name = "pat_pw_event_id",
                                    Value = dr["PAT_PW_EVENT_ID"].ToString(),
                                    Mode = ext.ParameterMode.Auto
                                }
                            //    new ext.ConfigItem{
                             //       Name = "pw_id",
                               //     Value = dr["PW_ID"].ToString(),
                                 //   Mode = ext.ParameterMode.Auto
                               // },
                              //  new ext.ConfigItem{
                                //    Name = "pw_event_id",
                                  //  Value = dr["PW_EVENT_ID"].ToString(),
                                    //Mode = ext.ParameterMode.Auto
                                //}
                            }
                        };

                        //if event is closed don't show the edit options
                        if (lEventStatus == 2)
                        {
                            //nInstr.Icon = ext.Icon.Error;

                            //mark as not an event so the user 
                            //does not see the +/- tool bar options
                            //0 = is_event
                            nPWEvt.CustomAttributes[0].Value = "false";
                        }


                        //render event instruments node
                        txtree.RenderEventInstruments(Convert.ToInt32(dr["PAT_PW_ID"]), Convert.ToInt32(dr["PAT_PW_EVENT_ID"]), nPWEvt);

                        nPWEvt.Icon = (nPWEvt.Children.Count > 0) ? ext.Icon.FolderPage : ext.Icon.Folder;


                        //add event node to the parent node
                        nRoot.Children.Add(nPWEvt);

                    }
                }
            }
        }

        nodes.Add(nRoot);
        tTxTree.SetRootNode(nodes[0]);

        ////hide tabs till something is selected
        //if (bHideTabs)
        //{
        //    tpPatientSummary.HideTab("pnlInstruments");
        //    tpPatientSummary.HideTab("pnlOutcomes");
        //    tpPatientSummary.HideTab("pnlPlan");
        //    tpPatientSummary.HideTab("pnlNote");
        //    tpPatientSummary.HideTab("pnlMedicalHx");
        //}
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// Render the filtered PW Evts nodes
    /// </summary>
    /// <param name="strPW"></param>
    public string GetFilteredPWEvt(string strPW) {
        var nodes = GetPWEventNodes(strPW);
        //tTxTree.Root.Add(nodes[0]);
        return nodes.ToJson();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn="fnReloadEventsNodes")]
    /// <summary>
    /// Reload the events nodes
    /// </summary>
    /// <param name="?"></param>
    /// <returns></returns>
    public long ReloadPWEventNodes(long lPatPWEventID) { 
        return lPatPWEventID;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "fnReloadEventsNodes")]
    /// <summary>
    /// Reload the events nodes
    /// </summary>
    /// <param name="?"></param>
    /// <returns></returns>
    public long ReloadPWEvtNodes()
    {
        //init the plan....
        ucPlan.InitializeControl(CDataUtils2.ToLong(PatPWEventID));

        return -1;
    }

    /// <summary>
    /// Gets all pathwways event nodes associated to a patient
    /// </summary>
    /// <returns></returns>
    protected Ext.Net.NodeCollection GetPWEventNodes(string strSelectedPW)
    {
        if (strSelectedPW != "")
        {
            SelectedPathways = strSelectedPW;
        }
        
        Ext.Net.NodeCollection nodes = new Ext.Net.NodeCollection();
        Ext.Net.Node nRoot = new Node() { Expanded = true, EmptyChildren = true };
        CTxTree txtree = new CTxTree(Master, "PATSUMMARY");
        txtree.RenderPWEvents(strSelectedPW, nRoot);
        nodes.Add(nRoot);
        return nodes;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", CompleteFn = "fnFilterPWEvents")]
    /// <summary>
    /// Loads a list of patient pathways for the selected Clinical Program Area
    /// </summary>
    public void LoadPatPathwaysList()
    {
        storePathways2.RemoveAll();
        gpPathwaysList2.Refresh();

        CCPA ccpa = new CCPA();
        DataSet ds = ccpa.GetPatPWDS(Master, Master.SelectedPatientID);

        storePathways2.RemoveAll();
        storePathways2.DataSource = ds.Tables[0];
        storePathways2.DataBind();
        gpPathwaysList2.Refresh();
    }

    [DirectMethod(ShowMask = true, Msg = "Please wait.", SuccessFn = "fnAfterAddingNewPathway")]
    public void LoadPatPWList2()
    {
        LoadPatPathwaysList();
        RenderNewestPathwayEvents();
    }
    
    [DirectMethod(ShowMask = true, Msg = "Please wait.")]
    /// <summary>
    /// Gets all the patient instruments
    /// </summary>
    public void GetAllPatPWEvtModules()
    {
        CCPA ccpa = new CCPA();
        DataSet ds = ccpa.GetAllPatPWEventModuleDS(Master, Master.SelectedPatientID);
        if (ds != null)
        {
            if (ds.Tables.Count > 0)
            {
                ds.Tables[0].Columns.Add(new DataColumn("SCORE", typeof(string)));
                ds.Tables[0].Columns.Add(new DataColumn("INTERPRETATION", typeof(string)));

                ds.Tables[0].DefaultView.RowFilter = "Status = 2";
                storeInstrument.DataSource = ds.Tables[0];
                storeInstrument.DataBind();
            }
        }
    }

    #endregion

    //[DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    ///// <summary>
    ///// Set active tab
    ///// </summary>
    ///// <param name="iActiveTab"></param>
    //public void SetActiveTab(int iActiveTab) 
    //{
    //    tpPatientSummary.ActiveTabIndex = iActiveTab;
    //}

    #region INSTRUMENTS

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", Timeout = 60000)]
    /// <summary>
    /// US:5966
    /// Renders the instrument in the instrument's tab
    /// </summary>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    /// <param name="lPatPWEventModuleID"></param>
    /// <param name="bReadOnly"></param>
    /// <returns></returns>    
    public ucTBICDSInstrument.InstrumentOptions LoadInstrument(long lMID, long lIntakeID, long lPatPWEventModuleID, bool bReadOnly)
    {
        //if intake is new then default to current date and time
        if (lIntakeID < 1)
        {
            dfAssessmentDate.SelectedDate = DateTime.Today;
            tfAssessmentTime.SelectedTime = new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);
        }
        else
        {
            //get the instrument date/time for the intake id and set it here
            CInstrumentResponse resp = new CInstrumentResponse(Master);
            DataSet ds = resp.GetPatientInstrumentsDS(Master.SelectedPatientID);
            foreach (DataTable dt in ds.Tables)
            {
                //clinical program area
                foreach (DataRow row in dt.Rows)
                {
                    long lID = CDataUtils2.GetDSLongValue(row, "INTAKE_ID");
                    if (lID == lIntakeID)
                    {
                        DateTime dtCompleteDate = CDataUtils2.GetDSDateTimeValue(row, "DATE_COMPLETED");
                        dfAssessmentDate.SelectedDate = dtCompleteDate;
                        tfAssessmentTime.SelectedTime = new TimeSpan(dtCompleteDate.Hour, dtCompleteDate.Minute, dtCompleteDate.Second);
                        break;
                    }
                }
            }

        }

        ucTBICDSInstrument.InstrumentOptions result = ucTBICDSInstrument.LoadInstrument(Master.SelectedPatientID, Master.SiteID.ToString(), lMID, lIntakeID, lPatPWEventModuleID, bReadOnly);
        aspPnlInstrumentContainer.Update();
        tpPatientSummary.ActiveTab = pnlInstruments;

        pnlInstruments.DoLayout();

        return result;
    }
   
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:6247
    /// Renders and shows the completed instrument report on screen
    /// </summary>
    /// <param name="strPatientID"></param>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    public object ShowInstrumentReport(string strPatientID, long lMID, long lIntakeID, long lFilter)
    {
        CInstrumentResponse inst = new CInstrumentResponse(Master);
        var obj = inst.GetInstrumentResponsesJSON(strPatientID, lMID, lIntakeID);
        Session["instrument_json"] = JsonConvert.SerializeObject(obj, Newtonsoft.Json.Formatting.None);
        pnlInstrumentReport.Update(obj);

        object oScore = inst.GetInstrumentScoreObj(strPatientID, lMID, lIntakeID, (CInstrumentResponse.ScoreFilter)lFilter);
        return oScore;
    }

    /// <summary>
    /// US:6247
    /// Converts the instrument data to CSV format
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ToCsv(object sender, EventArgs e)
    {
        this.Response.Clear();
        this.Response.ContentType = "application/octet-stream";
        this.Response.AddHeader("Content-Disposition", "attachment; filename=PatientInstrument.csv");

        //Get the json string for the current instrument from the session variable "instrument_json"
        if (Session["instrument_json"] != null)
        {
            CInstrumentResponse.ModelIntake.Module mod = JsonConvert.DeserializeObject<CInstrumentResponse.ModelIntake.Module>(Session["instrument_json"].ToString());

            // initialize the CSV string
            StringBuilder sb = new StringBuilder();

            //define the column headings
            //string[] strCols = { "INSTRUMENT_ID", "TOPIC_ID", "QUESTION_ID", "RESPONSE_ID", "QUESTION", "RESPONSE", "SCORE_VALUE" };
            //string[] strCols = { "INSTRUMENT_ID", "INSTRUMENT_NAME", "REPORT_SECTION", "ROW_TYPE", "COLUMN_1", "COLUMN_2", "COLUMN_3", "COLUMN_4", "COLUMN_5", "COLUMN_6" };
            string[] strCols = { "INSTRUMENT_ID", "INSTRUMENT_NAME", "COMPLETE_DATE", "REPORT_SECTION", "ROW_TYPE", "COLUMN_1", "COLUMN_2", "COLUMN_3", "COLUMN_4", "COLUMN_5", "COLUMN_6" };

            // append the columns to the string
            foreach (string c in strCols)
            {
                sb.Append(String.Format("\"{0}\",", c));
            }
            sb.Append(Environment.NewLine);


            //---------------------------------------------
            // SCORES
            //---------------------------------------------

            // Score Header
            if (mod.Scores.Count > 0)
            {
                sb.Append(String.Format("\"{0}\",", mod.MID.ToString()));
                sb.Append(String.Format("\"{0}\",", mod.ModuleTitle.ToString()));
                sb.Append(String.Format("\"{0}\",", mod.CompletedDate.ToString()));
                
                sb.Append("\"SCORES\",");
                sb.Append("\"HEADER\",");
                sb.Append("\"SERIES\",");
                sb.Append("\"DESCRIPTION\",");
                sb.Append("\"SCORE_VALUE\",");
                sb.Append("\"INTERPRETATION\",");
                sb.Append("");
                sb.Append("");
                sb.Append(Environment.NewLine);
            }

            // Score Data
            foreach (var t in mod.Scores)
            {
                sb.Append(String.Format("\"{0}\",", mod.MID.ToString()));
                sb.Append(String.Format("\"{0}\",", mod.ModuleTitle.ToString()));
                sb.Append(String.Format("\"{0}\",", mod.CompletedDate.ToString()));
              
                sb.Append("\"SCORES\",");
                sb.Append("\"DATA\",");
                
                sb.Append(String.Format("\"{0}\",", t.Series.ToString()));
                sb.Append(String.Format("\"{0}\",", t.Description.ToString()));
                sb.Append(String.Format("\"{0}\",", t.ScoreValue.ToString()));
                sb.Append(String.Format("\"{0}\",", t.Interpretation.ToString()));
                sb.Append("");
                sb.Append("");
                sb.Append(Environment.NewLine);
            }

            //---------------------------------------------
            // RESPONSES
            //---------------------------------------------
            // Responses Header
            sb.Append(String.Format("\"{0}\",", mod.MID.ToString()));
            sb.Append(String.Format("\"{0}\",", mod.ModuleTitle.ToString()));
            sb.Append(String.Format("\"{0}\",", mod.CompletedDate.ToString()));
          
            sb.Append("\"RESPONSES\",");
            sb.Append("\"HEADER\",");
            sb.Append("\"TOPIC_ID\",");
            sb.Append("\"QUESTION_ID\",");
            sb.Append("\"RESPONSE_ID\",");
            sb.Append("\"QUESTION\",");
            sb.Append("\"RESPONSE\",");
            sb.Append("\"WEIGHTED_VALUE\"");
            sb.Append(Environment.NewLine);

            // Responses Data
            //loop the "module" object to populate the file
            foreach (var t in mod.Topics)
            {
                foreach (var q in t.Questions)
                {
                    foreach (var r in q.Responses)
                    {
                        //mid
                        sb.Append(String.Format("\"{0}\",", mod.MID.ToString()));

                        //module name
                        sb.Append(String.Format("\"{0}\",", mod.ModuleTitle.ToString()));

                        //completed date
                        sb.Append(String.Format("\"{0}\",", mod.CompletedDate.ToString()));

                        sb.Append("\"RESPONSES\",");
                        sb.Append("\"DATA\",");

                        //tid
                        sb.Append(String.Format("\"{0}\",", t.TID.ToString()));

                        //qid
                        sb.Append(String.Format("\"{0}\",", q.QID.ToString()));

                        //rid
                        sb.Append(String.Format("\"{0}\",", r.RID.ToString()));

                        //question
                        string strQ = RemoveMutedTextForReport(q.QuestionTitle);
                        strQ = CSVString(strQ);
                        sb.Append(String.Format("\"{0}\",", strQ));

                        //RESPONSE
                        string strStaticResponse = String.Empty;
                        string strResponse = String.Empty;
                        string strUnit = String.Empty;

                        //static
                        if (!String.IsNullOrEmpty(CSVString(r.StaticResponseText)) && !String.IsNullOrWhiteSpace(CSVString(r.StaticResponseText)))
                        {
                            strStaticResponse = CSVString(r.StaticResponseText) + " ";
                        }

                        //response
                        strResponse = r.ResponseValue.Replace("\"", "\"\"");
                        strResponse = strResponse.Replace("\n", " "); //replace newline character

                        //unit
                        if (!String.IsNullOrEmpty(CSVString(r.ResponseUnit)) && !String.IsNullOrWhiteSpace(CSVString(r.ResponseUnit)))
                        {
                            strUnit = " " + CSVString(r.ResponseUnit);
                        }

                        //response
                        if (r.DisplayType == 3)
                        {
                            sb.Append(String.Format("\"{0}\",", strStaticResponse + strResponse + strUnit));
                        }
                        else if (r.DisplayType == 4 || r.DisplayType == 22)
                        {
                            sb.Append(String.Format("\"{0}\",", strStaticResponse + " " + strResponse));
                        }
                        else
                        {
                            sb.Append(String.Format("\"{0}\",", strResponse));
                        }

                        //score value
                        sb.Append(String.Format("\"{0}\"", r.ScoreValue.ToString()));

                        //end of line
                        sb.Append(Environment.NewLine);
                    }
                }
            }

            // build the response

            string strCSV = sb.ToString();

            byte[] byteArray = Encoding.UTF8.GetBytes(strCSV);
            this.Response.OutputStream.Write(byteArray, 0, byteArray.Length);

        }
        else
        {
            byte[] byteArray = Encoding.UTF8.GetBytes("\"INSTRUMENT_ID\", \"TOPIC_ID\", \"QUESTION_ID\", \"RESPONSE_ID\", \"QUESTION\", \"RESPONSE\", \"SCORE_VALUE\"");
            this.Response.OutputStream.Write(byteArray, 0, byteArray.Length);
        }

        this.Response.End();
    }

    /// <summary>
    /// Clear any HTML tag from the string and makes it CSV compatible.
    /// </summary>
    /// <param name="strValue"></param>
    /// <returns></returns>
    private string CSVString(string strValue)
    {
        string strNewValue = strValue;

        strNewValue = CHtmlRemoval.StripTagsRegexCompiled(strNewValue);
        strNewValue = strNewValue.Replace("\"", "\"\"");

        return strNewValue;
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ToXml(object sender, EventArgs e)
    {
        string json = this.GetReportJSON();
        StoreSubmitDataEventArgs eSubmit = new StoreSubmitDataEventArgs(json, null);
        XmlNode xml = eSubmit.Xml;

        string strXml = xml.OuterXml;

        this.Response.Clear();
        this.Response.AddHeader("Content-Disposition", "attachment; filename=PatientInstrument.xml");
        this.Response.AddHeader("Content-Length", strXml.Length.ToString());
        this.Response.ContentType = "application/xml";
        this.Response.Write(strXml);
        this.Response.End();
    }

    /// <summary>
    /// US:6247
    /// Converts the instrument data to Excel spreadsheet format
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ToExcel(object sender, EventArgs e)
    {
        string json = this.GetReportJSON();
        json = CHtmlRemoval.StripTagsRegexCompiled(json);

        StoreSubmitDataEventArgs eSubmit = new StoreSubmitDataEventArgs(json, null);
        XmlNode xml = eSubmit.Xml;

        this.Response.Clear();
        this.Response.ContentType = "application/vnd.ms-excel";
        this.Response.AddHeader("Content-Disposition", "attachment; filename=PatientInstrument.xls");

        XslCompiledTransform xtExcel = new XslCompiledTransform();

        xtExcel.Load(Server.MapPath("Excel.xsl"));
        xtExcel.Transform(xml, null, this.Response.OutputStream);
        this.Response.End();
    }

    /// <summary>
    /// US:6247
    /// Convert/Re-format the instrument_json session var
    /// </summary>
    /// <returns></returns>
    protected string GetReportJSON()
    {
        string strValue = "{}";
        if (Session["instrument_json"] != null)
        {

            string strJSON = Session["instrument_json"].ToString();
            var objMod = JsonConvert.DeserializeObject<CInstrumentResponse.ModelIntake.Module>(strJSON);
            var objNew = new List<object>();

            //main header
            var mh = new
            {
                A = "INSTRUMENT_ID",
                B = "INSTRUMENT_NAME",
                C = "REPORT_SECTION",
                D = "ROW_TYPE",
                E = "COLUMN_1",
                F = "COLUMN_2",
                G = "COLUMN_3",
                H = "COLUMN_4",
                I = "COLUMN_5",
                J = "COLUMN_6"
            };
            objNew.Add(mh);

            //scores
            //scores header
            var sh = new
            {
                instrument_id = objMod.MID,
                instrument_name = objMod.ModuleTitle,
                report_section = "SCORES",
                row_type = "HEADER",
                column_1 = "SERIES",
                column_2 = "DESCRIPTION",
                column_3 = "SCORE_VALUE",
                column_4 = "INTERPRETATION"
            };
            objNew.Add(sh);

            //scores data
            foreach (var t in objMod.Scores)
            {
                var o = new
                {
                    instrument_id = objMod.MID,
                    instrument_name = objMod.ModuleTitle,
                    report_section = "SCORES",
                    row_type = "DATA",
                    series = t.Series,
                    description = t.Description,
                    score_value = t.ScoreValue,
                    interpretation = t.Interpretation
                };
                objNew.Add(o);
            }

            //responses
            //responses header
            var rh = new
            {
                instrument_id = objMod.MID,
                instrument_name = objMod.ModuleTitle,
                report_section = "RESPONSES",
                D = "HEADER",
                E = "TOPIC_ID",
                F = "QUESTION_ID",
                G = "RESPONSE_ID",
                H = "QUESTION",
                I = "RESPONSE",
                J = "WEIGHTED_VALUE"
            };
            objNew.Add(rh);

            //responses data
            foreach (var t in objMod.Topics)
            {
                foreach (var q in t.Questions)
                {
                    foreach (var r in q.Responses)
                    {
                        var o = new
                        {
                            instrument_id = objMod.MID,
                            instrument_name = objMod.ModuleTitle,
                            report_section = "RESPONSES",
                            row_type = "DATA",
                            topic_id = t.TID,
                            question_id = q.QID,
                            response_id = r.RID,
                            question = q.QuestionTitle,
                            response = (r.DisplayType == 3) ? r.StaticResponseText + " " + r.ResponseValue + " " + r.ResponseUnit : r.ResponseValue,
                            weighted_value = r.ScoreValue
                        };
                        objNew.Add(o);
                    }
                }
            }

            strValue = JsonConvert.SerializeObject(objNew, Newtonsoft.Json.Formatting.Indented);
        }
        return strValue;
    }

    public string RemoveMutedTextForReport(string strText)
    {
        string strNewText = string.Empty;
        HtmlAgilityPack.HtmlDocument doc = new HtmlAgilityPack.HtmlDocument();
        doc.LoadHtml("<div>" + strText + "</div>");
        HtmlAgilityPack.HtmlNodeCollection nodesToRemove = doc.DocumentNode.SelectNodes("//span[@class='on-report-hide']");
        if (nodesToRemove != null)
        {
            foreach (var node in nodesToRemove)
            {
                node.Remove();
            } 
        }
        strNewText = doc.DocumentNode.InnerText;
        strNewText = strNewText.Replace("\r", string.Empty).Replace("\n", string.Empty);
        return strNewText;
    }


    #endregion

}